//Multi Sensor shield用サンプルコード
//約0.5秒ごとに各センサの値を読みだして
//SDカードに時間とともに書き込みます.
//SDに書き込む際にLEDが光ることで動作確認ができます.

#include <Wire.h>
#include <skMPL115A2.h>
#include <ADXL345.h>
#include <SD.h>
#include <RTC8564.h>

#define SENSOR_ADRS 0x60

skMPL115A2 Pa(SENSOR_ADRS) ;            // MPL115A2関数ライブラリを生成する

ADXL345 adxl; //variable adxl is an instance of the ADXL345 library

//for SD
const int chipSelect = 4;

/*******************************************************************************
*  電源起動時とリセットの時だけのみ処理される関数(初期化と設定処理)            *
*******************************************************************************/
void setup()
{
   // pin setting
   pinMode(2,OUTPUT);
   pinMode(3,OUTPUT);
   pinMode(5,OUTPUT);
   pinMode(6,OUTPUT);
   pinMode(7,OUTPUT);
   pinMode(8,OUTPUT);
   pinMode(9,OUTPUT);
   digitalWrite(2,LOW);
   digitalWrite(3,LOW);
   digitalWrite(5,LOW);
   digitalWrite(6,LOW);
   digitalWrite(7,LOW);
   digitalWrite(8,LOW);
   digitalWrite(9,LOW);
   
   Rtc.begin();
   delay(3000) ;     // 3Sしたら開始
   Pa.CoefficientRead() ;             // MPL115A2のメモリーマップから係数を読出して置く
   adxl.powerOn();
   
   //for SD
   pinMode(SS, OUTPUT);
   // SDライブラリを初期化
   if (!SD.begin(chipSelect)) {
     while(1);
   }
   // 日付と時刻を返す関数を登録
   SdFile::dateTimeCallback( &dateTime );
  
  //for ADXL345   
  //set activity/ inactivity thresholds (0-255)
  adxl.setActivityThreshold(75); //62.5mg per increment
  adxl.setInactivityThreshold(75); //62.5mg per increment
  adxl.setTimeInactivity(10); // how many seconds of no activity is inactive?
 
  //look of activity movement on this axes - 1 == on; 0 == off 
  adxl.setActivityX(1);
  adxl.setActivityY(1);
  adxl.setActivityZ(1);
 
  //look of inactivity movement on this axes - 1 == on; 0 == off
  adxl.setInactivityX(1);
  adxl.setInactivityY(1);
  adxl.setInactivityZ(1);
 
  //look of tap movement on this axes - 1 == on; 0 == off
  adxl.setTapDetectionOnX(0);
  adxl.setTapDetectionOnY(0);
  adxl.setTapDetectionOnZ(1);
 
  //set values for what is a tap, and what is a double tap (0-255)
  adxl.setTapThreshold(50); //62.5mg per increment
  adxl.setTapDuration(15); //625us per increment
  adxl.setDoubleTapLatency(80); //1.25ms per increment
  adxl.setDoubleTapWindow(200); //1.25ms per increment
 
  //set values for what is considered freefall (0-255)
  adxl.setFreeFallThreshold(7); //(5 - 9) recommended - 62.5mg per increment
  adxl.setFreeFallDuration(45); //(20 - 70) recommended - 5ms per increment
 
  //setting all interrupts to take place on int pin 1
  //I had issues with int pin 2, was unable to reset it
  adxl.setInterruptMapping( ADXL345_INT_SINGLE_TAP_BIT,   ADXL345_INT1_PIN );
  adxl.setInterruptMapping( ADXL345_INT_DOUBLE_TAP_BIT,   ADXL345_INT1_PIN );
  adxl.setInterruptMapping( ADXL345_INT_FREE_FALL_BIT,    ADXL345_INT1_PIN );
  adxl.setInterruptMapping( ADXL345_INT_ACTIVITY_BIT,     ADXL345_INT1_PIN );
  adxl.setInterruptMapping( ADXL345_INT_INACTIVITY_BIT,   ADXL345_INT1_PIN );
 
  //register interrupt actions - 1 == on; 0 == off  
  adxl.setInterrupt( ADXL345_INT_SINGLE_TAP_BIT, 1);
  adxl.setInterrupt( ADXL345_INT_DOUBLE_TAP_BIT, 1);
  adxl.setInterrupt( ADXL345_INT_FREE_FALL_BIT,  1);
  adxl.setInterrupt( ADXL345_INT_ACTIVITY_BIT,   1);
  adxl.setInterrupt( ADXL345_INT_INACTIVITY_BIT, 1);
  //END of ADXL345
}
/*******************************************************************************
*  繰り返し実行される処理の関数(メインの処理)                                  *
*******************************************************************************/
void loop()
{
     //for RTC
     Rtc.available();
     
     //for SD
     File dataFile = SD.open("datalog.txt", FILE_WRITE);
     
     float air_p;
     int i = 0;
     int rad1 = 0;
     int rad2 = 0;
     int light = 0;
     float temp = 0;
     int s_val;
     air_p = Pa.PressureAVE(20) ;              // 平均化された気圧値の計算を行う
     
     //switch sensors and read value
     digitalWrite(9,HIGH);
     rad1 = analogRead(2);//gyro 1
     digitalWrite(9,LOW);
     digitalWrite(6,HIGH);
     rad2 = analogRead(2);//gyro 2
     digitalWrite(6,LOW);
     digitalWrite(8,HIGH);
     light = analogRead(2);//light sensor
     digitalWrite(8,LOW);
     temp = analogRead(0)*500/((float)1024);//temperature sensor
     
     //smell sensor
     digitalWrite(5,HIGH);
     digitalWrite(3,HIGH);
     delay(8);
     digitalWrite(3,LOW);
     delay(237);
     digitalWrite(2,HIGH);
     delay(2);
     s_val = analogRead(2);
     delay(3);
     digitalWrite(2,LOW);
     digitalWrite(5,LOW);
     
     //Boring accelerometer stuff   
     int x,y,z;  
     adxl.readAccel(&x, &y, &z); //read the accelerometer values and store them in variables  x,y,
     double xyz[3];
     double ax,ay,az;
     adxl.get_Gxyz(xyz);
     ax = xyz[0];
     ay = xyz[1];
     az = xyz[2];

     //write data to microSD
     if (dataFile) {
        digitalWrite(7,HIGH);//LED on
        dataFile.print(0x2000+Rtc.years(),HEX);
        dataFile.print("/");
        dataFile.print(Rtc.months(),HEX);
        dataFile.print("/");
        dataFile.print(Rtc.days(),HEX);
        dataFile.print(" ");
        dataFile.print(Rtc.hours(),HEX);
        dataFile.print(":");
        dataFile.print(Rtc.minutes(),HEX);
        dataFile.print(":");
        dataFile.print(Rtc.seconds(),HEX);
        dataFile.print(",");
        dataFile.print(air_p);
        dataFile.print(",");
        dataFile.print(ax);
        dataFile.print(",");
        dataFile.print(ay);
        dataFile.print(",");
        dataFile.print(az);
        dataFile.print(",");
        dataFile.print(rad1);
        dataFile.print(",");
        dataFile.print(rad2);
        dataFile.print(",");
        dataFile.print(light);
        dataFile.print(",");
        dataFile.print(temp,1);
        dataFile.print(",");
        dataFile.println(s_val);
        dataFile.close();
        digitalWrite(7,LOW);//LED off
      }
      // ファイルが開けなかった場合
      else {
      }
        
     delay(250) ;                           // 約0.5秒ごとに繰り返す
}

void dateTime(uint16_t* date, uint16_t* time)
{
  uint16_t year = 2013;
  uint8_t month = 2, day = 3, hour = 9, minute = 0, second = 0;

  // GPSやRTCから日付と時間を取得
  // FAT_DATEマクロでフィールドを埋めて日付を返す
  *date = FAT_DATE(year, month, day);

  // FAT_TIMEマクロでフィールドを埋めて時間を返す
  *time = FAT_TIME(hour, minute, second);
}
