/*******************************************************************************
*  pressure - 気圧センサーのMPL115A2で大気圧を測定するプログラム               *
*                                                                              *
*       メモ： Arduino IDE のシステムモニターに大気圧と高度(標高)を表示します。*
*              Arduino とはＩ２Ｃで接続します。                                *
*                                                                              *
* ============================================================================ *
*  VERSION DATE        BY                    CHANGE/COMMENT                    *
* ---------------------------------------------------------------------------- *
*  1.00    2013-01-05  きむ茶工房(きむしげ)  Create                            *
* ============================================================================ *
*  Arduino IDE 1.0.1 (Ardino Duemilanove 328)                                  *
*******************************************************************************/
#include <Wire.h>
#include <skMPL115A2.h>

#define SENSOR_ADRS 0x60                // MPL115A2のI2Cアドレス
#define H_CORRECT   80                  // 自宅でのセンサと実際の高度差補正値(My自宅の標高は100m)

skMPL115A2 Pa(SENSOR_ADRS) ;            // MPL115A2関数ライブラリを生成する

/*******************************************************************************
*  電源起動時とリセットの時だけのみ処理される関数(初期化と設定処理)            *
*******************************************************************************/
void setup()
{
     // シリアルモニターの設定
     Serial.begin(9600) ;

     delay(3000) ;                      // 3Sしたら開始
     Pa.CoefficientRead() ;             // MPL115A2のメモリーマップから係数を読出して置く
}
/*******************************************************************************
*  繰り返し実行される処理の関数(メインの処理)                                  *
*******************************************************************************/
void loop()
{
     float ans ;

     ans = Pa.PressureAVE(20) ;              // 平均化された気圧値の計算を行う
     Serial.print(ans) ;                     // 気圧値の表示を行う
     Serial.print(" hPa    ") ;
     ans = Pa.AltitudeCalc(ans,H_CORRECT) ;  // 高度の計算を行う
     Serial.print(ans) ;                     // 高度の表示を行う
     Serial.println(" m") ;

     delay(1000) ;                           // １秒後に繰り返す
}
